/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.etcetera.block.enums;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public enum DrumType implements StringRepresentable
{
    BEATBOX("beatbox"),
    DARBUKA("darbuka"),
    DHOLAK("dholak"),
    DJEMBE("djembe"),
    TABLA("tabla");

    private final String name;

    private DrumType(String name) {
        this.name = name;
    }

    public SoundEvent getHighSound() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("etcetera", "block.drum." + this.name + ".high"));
    }

    public SoundEvent getMediumSound() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("etcetera", "block.drum." + this.name + ".medium"));
    }

    public SoundEvent getLowSound() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("etcetera", "block.drum." + this.name + ".low"));
    }

    public static DrumType fromBlockState(BlockState state) {
        if (state.m_60713_(Blocks.f_50133_)) {
            return BEATBOX;
        }
        if (state.m_60713_(Blocks.f_50074_)) {
            return DARBUKA;
        }
        if (state.m_60713_(Blocks.f_50075_)) {
            return DHOLAK;
        }
        if (state.m_60713_(Blocks.f_49992_)) {
            return TABLA;
        }
        return DJEMBE;
    }

    public String m_7912_() {
        return this.name;
    }
}

