/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.etcetera.block;

import com.ninni.etcetera.block.AbstractLightBulbBlock;
import com.ninni.etcetera.block.entity.TintedLightBulbBlockEntity;
import com.ninni.etcetera.block.enums.LightBulbBrightness;
import com.ninni.etcetera.registry.EtceteraBlockEntityType;
import net.minecraft.core.BlockPos;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class TintedLightBulbBlock
extends AbstractLightBulbBlock
implements EntityBlock {
    public TintedLightBulbBlock(BlockBehaviour.Properties settings) {
        super(settings.m_60953_(TintedLightBulbBlock::getLuminance));
    }

    public static int getLuminance(BlockState state) {
        LightBulbBrightness brightness = (LightBulbBrightness)((Object)state.m_61143_((Property)BRIGHTNESS));
        if (brightness == LightBulbBrightness.DARK) {
            return 3;
        }
        if (brightness == LightBulbBrightness.DIM) {
            return 6;
        }
        if (brightness == LightBulbBrightness.BRIGHT) {
            return 10;
        }
        return 0;
    }

    @Override
    public void turnBrightness(BlockState state, Level world, BlockPos pos, LightBulbBrightness brightness) {
        super.turnBrightness(state, world, pos, brightness);
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof TintedLightBulbBlockEntity) {
            TintedLightBulbBlockEntity tintedLightBulbBlockEntity = (TintedLightBulbBlockEntity)blockEntity;
            if (state.m_61143_((Property)BRIGHTNESS) == LightBulbBrightness.OFF) {
                tintedLightBulbBlockEntity.setTicksBeforeFlicker(this.getTicksBeforeFlicker(world));
            }
        }
    }

    public int getTicksBeforeFlicker(Level world) {
        return UniformInt.m_146622_((int)200, (int)1000).m_214085_(world.m_213780_());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TintedLightBulbBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world2, BlockState p_153213_, BlockEntityType<T> type) {
        return !world2.f_46443_ && EtceteraBlockEntityType.TINTED_LIGHT_BULB.get() == type ? (world, pos, state1, blockEntity) -> {
            TintedLightBulbBlockEntity tintedLightBulbBlockEntity = (TintedLightBulbBlockEntity)blockEntity;
            tintedLightBulbBlockEntity.tick(world, pos, state1, tintedLightBulbBlockEntity);
        } : null;
    }
}

