/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.etcetera.block;

import com.ninni.etcetera.block.enums.DrumType;
import com.ninni.etcetera.registry.EtceteraProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DrumBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final EnumProperty<DrumType> TYPE = EtceteraProperties.DRUM_TYPE;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape SHAPE = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), (VoxelShape)Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.f_82695_);
    protected static final VoxelShape HIT_SHAPE = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)-0.25, (double)8.0, (double)-0.25, (double)16.25, (double)15.75, (double)16.25), (VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), (BooleanOp)BooleanOp.f_82695_);

    public DrumBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_(TYPE, (Comparable)((Object)DrumType.DJEMBE)));
    }

    public void playDrumSound(BlockState state, Level world, BlockPos pos, Entity player, Vec3 hit) {
        world.m_142346_(player, GameEvent.f_157792_, pos);
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
        world.m_186460_(pos, (Block)this, this.getPressTicks());
        int power = this.calculatePower(hit);
        if (power >= 1 && 5 >= power) {
            world.m_7106_((ParticleOptions)ParticleTypes.f_123758_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.2, (double)pos.m_123343_() + 0.5, 0.6666666666666666, 0.0, 0.0);
            world.m_5594_(null, pos, this.getType(state).getHighSound(), SoundSource.RECORDS, 2.0f, 1.0f);
        }
        if (power > 5 && 11 >= power) {
            world.m_7106_((ParticleOptions)ParticleTypes.f_123758_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.2, (double)pos.m_123343_() + 0.5, 0.3333333333333333, 0.0, 0.0);
            world.m_5594_(null, pos, this.getType(state).getMediumSound(), SoundSource.RECORDS, 2.0f, 1.0f);
        }
        if (power > 11) {
            world.m_7106_((ParticleOptions)ParticleTypes.f_123758_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.2, (double)pos.m_123343_() + 0.5, 0.041666666666666664, 0.0, 0.0);
            world.m_5594_(null, pos, this.getType(state).getLowSound(), SoundSource.RECORDS, 2.0f, 1.0f);
        }
    }

    private int getPressTicks() {
        return 3;
    }

    private DrumType getType(BlockState state) {
        return (DrumType)((Object)state.m_61143_(TYPE));
    }

    private int calculatePower(Vec3 pos) {
        return Math.max(1, Mth.m_14165_((double)(15.0 * Mth.m_14008_((double)((0.5 - Math.max(Math.abs(Mth.m_14185_((double)pos.f_82479_) - 0.5), Math.abs(Mth.m_14185_((double)pos.f_82481_) - 0.5))) / 0.5), (double)0.0, (double)1.0))));
    }

    public void m_5581_(Level world, BlockState state, BlockHitResult hit, Projectile projectile) {
        if (hit.m_82434_() == Direction.UP) {
            this.playDrumSound(state, world, hit.m_82425_(), projectile.m_19749_(), hit.m_82450_());
        }
    }

    public void m_142072_(Level world, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        this.playDrumSound(state, world, pos, entity, entity.m_20182_());
        super.m_142072_(world, state, pos, entity, fallDistance);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand p_60507_, BlockHitResult hit) {
        if (hit.m_82434_() == Direction.UP && world.m_8055_(pos.m_7494_()).m_60795_()) {
            this.playDrumSound(state, world, pos, (Entity)player, hit.m_82450_());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos blockPos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)POWERED) != false ? HIT_SHAPE : SHAPE;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource p_222948_) {
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public int m_6378_(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        return (Boolean)state.m_61143_((Property)POWERED) != false ? 3 : 0;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return direction == Direction.DOWN ? (BlockState)state.m_61124_(TYPE, (Comparable)((Object)DrumType.fromBlockState(neighborState))) : super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.m_43725_().m_6425_(ctx.m_8083_()).m_76152_() == Fluids.f_76193_))).m_61124_(TYPE, (Comparable)((Object)DrumType.fromBlockState(ctx.m_43725_().m_8055_(ctx.m_8083_().m_7495_()))));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, POWERED, TYPE});
    }
}

