/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.depositor;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import dev.ithundxr.createnumismatics.base.block.NotifyFailedBreak;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import dev.ithundxr.createnumismatics.content.backend.TrustedBlock;
import dev.ithundxr.createnumismatics.content.depositor.AbstractDepositorBlockEntity;
import dev.ithundxr.createnumismatics.registry.NumismaticsItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDepositorBlock<T extends AbstractDepositorBlockEntity>
extends Block
implements IWrenchable,
IBE<T>,
TrustedBlock,
NotifyFailedBreak {
    public static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty LOCKED = BlockStateProperties.f_61444_;

    public AbstractDepositorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LOCKED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)HORIZONTAL_FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public int m_6378_(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull Direction direction) {
        return (Boolean)state.m_61143_((Property)POWERED) != false ? 15 : 0;
    }

    public boolean m_7899_(@NotNull BlockState state) {
        return true;
    }

    public void m_213897_(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        boolean powered = (Boolean)state.m_61143_((Property)POWERED);
        if (powered) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public void activate(BlockState state, Level level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.activate(state, serverLevel, pos);
        }
    }

    public void activate(BlockState state, ServerLevel level, BlockPos pos) {
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue() || ((Boolean)state.m_61143_((Property)LOCKED)).booleanValue()) {
            return;
        }
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
        level.m_5594_(null, pos, SoundEvents.f_11686_, SoundSource.BLOCKS, 0.5f, 1.0f);
        if (!level.m_183326_().m_183582_(pos, (Object)state.m_60734_())) {
            level.m_186460_(pos, state.m_60734_(), 2);
        }
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)HORIZONTAL_FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)HORIZONTAL_FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)HORIZONTAL_FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HORIZONTAL_FACING, POWERED, LOCKED});
    }

    public void m_6402_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        if (placer instanceof Player) {
            Player player = (Player)placer;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof AbstractDepositorBlockEntity) {
                AbstractDepositorBlockEntity depositorBE = (AbstractDepositorBlockEntity)blockEntity;
                depositorBE.owner = player.m_20148_();
            }
        }
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        if (!this.isTrusted(context.m_43723_(), (BlockGetter)context.m_43725_(), context.m_8083_())) {
            return InteractionResult.FAIL;
        }
        return super.onSneakWrenched(state, context);
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        if (!this.isTrusted(context.m_43723_(), (BlockGetter)context.m_43725_(), context.m_8083_())) {
            return InteractionResult.FAIL;
        }
        return super.onWrenched(state, context);
    }

    public float m_5880_(@NotNull BlockState state, @NotNull Player player, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        if (!this.isTrusted(player, level, pos)) {
            return 0.0f;
        }
        return super.m_5880_(state, player, level, pos);
    }

    public void m_6861_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos fromPos, boolean isMoving) {
        boolean shouldLock;
        if (level.f_46443_) {
            return;
        }
        boolean locked = (Boolean)state.m_61143_((Property)LOCKED);
        if (locked ^ (shouldLock = level.m_276867_(pos))) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)LOCKED, (Comparable)Boolean.valueOf(shouldLock)), 2);
        }
    }

    public void m_6810_(BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60713_(newState.m_60734_())) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof AbstractDepositorBlockEntity) {
            AbstractDepositorBlockEntity abstractDepositorBE = (AbstractDepositorBlockEntity)blockEntity;
            for (Coin coin : Coin.values()) {
                int count = abstractDepositorBE.inventory.getDiscrete(coin);
                if (count <= 0) continue;
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)NumismaticsItems.getCoin(coin).asStack(count));
                abstractDepositorBE.inventory.setDiscrete(coin, 0);
            }
        }
        IBE.onRemove((BlockState)state, (Level)level, (BlockPos)pos, (BlockState)newState);
    }

    @Override
    public void notifyFailedBreak(LevelAccessor level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof AbstractDepositorBlockEntity) {
            AbstractDepositorBlockEntity abstractDepositorBE = (AbstractDepositorBlockEntity)blockEntity;
            abstractDepositorBE.notifyDelayedDataSync();
        }
    }
}

