/*
 * Decompiled with CFR 0.152.
 */
package com.coldspell.balloonbox.events;

import com.coldspell.balloonbox.entities.entity.BalloonEntity;
import com.coldspell.balloonbox.util.ConfigHandler;
import com.coldspell.balloonbox.util.Utilities;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="balloonbox")
public class Events {
    private static final String DROPPED = "balloonTYPE";
    private static final ResourceLocation RED_BALLOON_LOOT_TABLE = new ResourceLocation("balloonbox", "chests/balloon_chest_red");
    private static final ResourceLocation BLUE_BALLOON_LOOT_TABLE = new ResourceLocation("balloonbox", "chests/balloon_chest_blue");
    private static final ResourceLocation GREEN_BALLOON_LOOT_TABLE = new ResourceLocation("balloonbox", "chests/balloon_chest_green");
    private static final ResourceLocation YELLOW_BALLOON_LOOT_TABLE = new ResourceLocation("balloonbox", "chests/balloon_chest_yellow");
    private static final ResourceLocation PINK_BALLOON_LOOT_TABLE = new ResourceLocation("balloonbox", "chests/balloon_chest_pink");
    private static final ResourceLocation RARE_BALLOON_LOOT_TABLE = new ResourceLocation("balloonbox", "chests/balloon_chest_rare");
    private static final ResourceLocation SIMPLE_DUNGEON_LOOT_TABLE = new ResourceLocation("minecraft", "chests/simple_dungeon");
    private static final ResourceLocation END_CITY_LOOT_TABLE = new ResourceLocation("minecraft", "chests/end_city_treasure");
    private static final int chestRange = 30;

    @SubscribeEvent
    public static void popBalloon(@NotNull LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof BalloonEntity) {
            BalloonEntity balloon = (BalloonEntity)livingEntity;
            ItemStack itemStack = new ItemStack((ItemLike)Items.f_42009_, 1);
            CompoundTag tag = itemStack.m_41784_();
            tag.m_128405_(DROPPED, balloon.getBalloonType());
            if (tag.m_128451_(DROPPED) == 5) {
                itemStack.m_41714_((Component)Component.m_237115_((String)"Rare Balloon Box"));
            } else {
                itemStack.m_41714_((Component)Component.m_237115_((String)"Balloon Box"));
            }
            ItemEntity itemEntity = new ItemEntity(balloon.m_9236_(), balloon.m_20185_() + 0.5, balloon.m_20186_(), balloon.m_20189_() + 0.5, itemStack);
            itemEntity.m_5825_();
            balloon.m_9236_().m_7967_((Entity)itemEntity);
            balloon.m_146870_();
        }
    }

    @SubscribeEvent
    public static void spawnEvent(PlayerWakeUpEvent event) {
        Utilities.spawnCheck(event);
    }

    @SubscribeEvent
    public static void chestEvent(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        Level level = player.m_9236_();
        List nearbyItems = level.m_45976_(ItemEntity.class, player.m_20191_().m_82377_(30.0, 30.0, 30.0));
        if (!nearbyItems.isEmpty()) {
            int count = nearbyItems.size();
            ItemEntity itemEntity = (ItemEntity)nearbyItems.get(player.m_217043_().m_188503_(count));
            if (itemEntity.m_32055_().m_41720_() == Items.f_42009_ && (itemEntity.m_32055_().m_41786_().getString().equals("Rare Balloon Box") || itemEntity.m_32055_().m_41786_().getString().equals("Balloon Box"))) {
                if (level.m_8055_(itemEntity.m_20183_().m_7495_()).m_60713_(Blocks.f_49990_) && ((Boolean)ConfigHandler.SETTINGS.loseChestWater.get()).booleanValue()) {
                    itemEntity.m_146870_();
                } else if (level.m_8055_(itemEntity.m_20183_().m_7495_()).m_60713_(Blocks.f_49991_) && ((Boolean)ConfigHandler.SETTINGS.loseChestLava.get()).booleanValue()) {
                    itemEntity.m_146870_();
                }
            }
        }
    }

    @SubscribeEvent
    public static void placeChest(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        Block block = event.getPlacedBlock().m_60734_();
        BlockPos chestPos = event.getPos();
        if (block instanceof ChestBlock && entity instanceof Player) {
            Player player = (Player)entity;
            ItemStack itemStack = player.m_21205_();
            CompoundTag tag = itemStack.m_41784_();
            Level level = player.m_9236_();
            if (tag.m_128441_(DROPPED)) {
                if (((Boolean)ConfigHandler.SETTINGS.useSimpleLoot.get()).booleanValue()) {
                    if (tag.m_128451_(DROPPED) == 0 || tag.m_128451_(DROPPED) == 1 || tag.m_128451_(DROPPED) == 3 || tag.m_128451_(DROPPED) == 4 || tag.m_128451_(DROPPED) == 2) {
                        RandomizableContainerBlockEntity.m_222766_((BlockGetter)level, (RandomSource)player.m_217043_(), (BlockPos)chestPos, (ResourceLocation)SIMPLE_DUNGEON_LOOT_TABLE);
                    } else if (tag.m_128451_(DROPPED) == 5) {
                        RandomizableContainerBlockEntity.m_222766_((BlockGetter)level, (RandomSource)player.m_217043_(), (BlockPos)chestPos, (ResourceLocation)END_CITY_LOOT_TABLE);
                    }
                } else if (tag.m_128451_(DROPPED) == 0) {
                    RandomizableContainerBlockEntity.m_222766_((BlockGetter)level, (RandomSource)player.m_217043_(), (BlockPos)chestPos, (ResourceLocation)RED_BALLOON_LOOT_TABLE);
                } else if (tag.m_128451_(DROPPED) == 1) {
                    RandomizableContainerBlockEntity.m_222766_((BlockGetter)level, (RandomSource)player.m_217043_(), (BlockPos)chestPos, (ResourceLocation)BLUE_BALLOON_LOOT_TABLE);
                } else if (tag.m_128451_(DROPPED) == 2) {
                    RandomizableContainerBlockEntity.m_222766_((BlockGetter)level, (RandomSource)player.m_217043_(), (BlockPos)chestPos, (ResourceLocation)GREEN_BALLOON_LOOT_TABLE);
                } else if (tag.m_128451_(DROPPED) == 3) {
                    RandomizableContainerBlockEntity.m_222766_((BlockGetter)level, (RandomSource)player.m_217043_(), (BlockPos)chestPos, (ResourceLocation)YELLOW_BALLOON_LOOT_TABLE);
                } else if (tag.m_128451_(DROPPED) == 4) {
                    RandomizableContainerBlockEntity.m_222766_((BlockGetter)level, (RandomSource)player.m_217043_(), (BlockPos)chestPos, (ResourceLocation)PINK_BALLOON_LOOT_TABLE);
                } else if (tag.m_128451_(DROPPED) == 5) {
                    RandomizableContainerBlockEntity.m_222766_((BlockGetter)level, (RandomSource)player.m_217043_(), (BlockPos)chestPos, (ResourceLocation)RARE_BALLOON_LOOT_TABLE);
                }
            }
        }
    }
}

