/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds.engine;

import java.lang.reflect.Field;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.HolderLookup;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import team.creative.ambientsounds.AmbientSounds;
import team.creative.ambientsounds.dimension.AmbientDimension;
import team.creative.ambientsounds.engine.AmbientEngine;
import team.creative.ambientsounds.environment.AmbientEnvironment;
import team.creative.ambientsounds.region.AmbientRegion;
import team.creative.ambientsounds.sound.AmbientSound;
import team.creative.ambientsounds.sound.AmbientSoundCategory;
import team.creative.ambientsounds.sound.AmbientSoundEngine;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.Side;
import team.creative.creativecore.client.render.text.DebugTextRenderer;
import team.creative.creativecore.common.config.holder.ConfigHolderDynamic;
import team.creative.creativecore.common.config.holder.CreativeConfigRegistry;
import team.creative.creativecore.common.config.sync.ConfigSynchronization;
import team.creative.creativecore.reflection.ReflectionHelper;

public class AmbientTickHandler {
    private static Minecraft mc = Minecraft.m_91087_();
    public AmbientSoundEngine soundEngine;
    public AmbientEnvironment environment = null;
    public AmbientEngine engine;
    public int timer = 0;
    public boolean showDebugInfo = false;
    private boolean shouldReload = false;

    public void scheduleReload() {
        this.shouldReload = true;
    }

    public void setEngine(AmbientEngine engine) {
        this.engine = engine;
        this.initConfiguration();
    }

    public void initConfiguration() {
        CreativeConfigRegistry.ROOT.removeField("ambientsounds");
        ConfigHolderDynamic holder = CreativeConfigRegistry.ROOT.registerFolder("ambientsounds", ConfigSynchronization.CLIENT);
        holder.registerValue("general", (Object)AmbientSounds.CONFIG);
        if (this.engine == null) {
            return;
        }
        ConfigHolderDynamic dimensions = holder.registerFolder("dimensions");
        Field dimensionField = ReflectionHelper.findField(AmbientDimension.class, (String)"volumeSetting");
        for (AmbientDimension dimension : this.engine.dimensions.values()) {
            dimensions.registerField(dimension.name, dimensionField, (Object)dimension);
        }
        ConfigHolderDynamic regions = holder.registerFolder("regions");
        Field regionField = ReflectionHelper.findField(AmbientRegion.class, (String)"volumeSetting");
        Field soundField = ReflectionHelper.findField(AmbientSound.class, (String)"volumeSetting");
        for (Map.Entry<String, AmbientRegion> pair : this.engine.allRegions.entrySet()) {
            ConfigHolderDynamic region = regions.registerFolder(pair.getKey().replace(".", "_"));
            region.registerField("overall", regionField, (Object)pair.getValue());
            if (pair.getValue().loadedSounds == null) continue;
            for (AmbientSound sound : pair.getValue().loadedSounds.values()) {
                region.registerField(sound.name, soundField, (Object)sound);
            }
        }
        ConfigHolderDynamic categories = holder.registerFolder("categories");
        Field categoryField = ReflectionHelper.findField(AmbientSoundCategory.class, (String)"volumeSetting");
        for (AmbientSoundCategory cat : this.engine.sortedSoundCategories) {
            this.createSoundCategoryConfiguration(categories, cat, categoryField);
        }
        holder.registerField("fade-volume", ReflectionHelper.findField(AmbientEngine.class, (String)"fadeVolume"), (Object)this.engine);
        holder.registerField("fade-pitch", ReflectionHelper.findField(AmbientEngine.class, (String)"fadePitch"), (Object)this.engine);
        holder.registerField("silent-dimensions", ReflectionHelper.findField(AmbientEngine.class, (String)"silentDimensions"), (Object)this.engine);
        CreativeCore.CONFIG_HANDLER.load((HolderLookup.Provider)(Minecraft.m_91087_().f_91073_ != null ? Minecraft.m_91087_().f_91073_.m_9598_() : null), "ambientsounds", Side.CLIENT);
    }

    private void createSoundCategoryConfiguration(ConfigHolderDynamic parent, AmbientSoundCategory cat, Field categoryField) {
        if (!cat.children.isEmpty()) {
            parent = parent.registerFolder(cat.name);
        }
        parent.registerField(cat.name, categoryField, (Object)cat);
        for (AmbientSoundCategory child : cat.children) {
            this.createSoundCategoryConfiguration(parent, child, categoryField);
        }
    }

    public void onRender(Object object) {
        if (this.showDebugInfo && this.engine != null && !mc.m_91104_() && this.environment != null && AmbientTickHandler.mc.f_91073_ != null) {
            GuiGraphics graphics = (GuiGraphics)object;
            DebugTextRenderer text = new DebugTextRenderer();
            this.engine.collectDetails(text);
            text.detail("playing", (Object)this.engine.soundEngine.playingCount()).detail("dim-name", (Object)AmbientTickHandler.mc.f_91073_.m_46472_().m_135782_()).newLine();
            this.environment.collectLevelDetails(text);
            text.newLine();
            this.environment.collectPlayerDetails(text, (Player)AmbientTickHandler.mc.f_91074_);
            text.newLine();
            this.environment.collectTerrainDetails(text);
            text.newLine();
            this.environment.collectBiomeDetails(text);
            text.newLine();
            for (AmbientSoundCategory cat : this.engine.sortedSoundCategories) {
                cat.collectDetails(text);
            }
            text.newLine();
            for (AmbientRegion region : this.engine.activeRegions) {
                text.detail("region", (Object)(ChatFormatting.DARK_GREEN + region.name + ChatFormatting.RESET));
                text.detail("playing", (Object)region.playing.size());
                text.newLine();
                for (AmbientSound sound : region.playing) {
                    if (!sound.isPlaying()) continue;
                    if (sound.stream1 != null) {
                        sound.stream1.collectDetails(text);
                    }
                    if (sound.stream2 != null) {
                        sound.stream2.collectDetails(text);
                    }
                    text.newLine();
                }
            }
            text.render(AmbientTickHandler.mc.f_91062_, graphics);
        }
    }

    public void loadLevel(LevelAccessor level) {
        if (level.m_5776_() && this.engine != null) {
            this.engine.onClientLoad();
        }
    }

    public void onTick() {
        if (this.soundEngine == null) {
            this.soundEngine = new AmbientSoundEngine();
            if (this.engine == null) {
                this.setEngine(AmbientEngine.loadAmbientEngine(this.soundEngine));
            }
            if (this.engine != null) {
                this.engine.soundEngine = this.soundEngine;
            }
        }
        if (this.shouldReload) {
            AmbientSounds.reloadAsync();
            this.shouldReload = false;
        }
        if (this.engine == null) {
            return;
        }
        ClientLevel level = AmbientTickHandler.mc.f_91073_;
        LocalPlayer player = AmbientTickHandler.mc.f_91074_;
        if (level != null && player != null && AmbientTickHandler.mc.f_91066_.m_92147_(SoundSource.AMBIENT) > 0.0f) {
            AmbientDimension newDimension;
            if (mc.m_91104_()) {
                return;
            }
            if (this.environment == null) {
                this.environment = new AmbientEnvironment();
            }
            if (this.environment.dimension != (newDimension = this.engine.getDimension((Level)level))) {
                this.engine.changeDimension(this.environment, newDimension);
                this.environment.dimension = newDimension;
            }
            if (this.timer % this.engine.environmentTickTime == 0) {
                this.environment.analyzeSlow(newDimension, this.engine, (Player)player, (Level)level, this.timer);
            }
            if (this.timer % this.engine.soundTickTime == 0) {
                this.environment.analyzeFast(newDimension, (Player)player, (Level)level, mc.m_91297_());
                this.environment.dimension.manipulateEnviroment(this.environment);
                this.engine.tick(this.environment);
            }
            this.engine.fastTick(this.environment);
            ++this.timer;
        } else if (!this.engine.activeRegions.isEmpty()) {
            this.engine.stopEngine();
        }
    }
}

