/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.common;

import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IItemNode;
import com.yanny.ali.api.ILootModifier;
import com.yanny.ali.api.IOperation;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.ListNode;
import com.yanny.ali.api.TooltipNode;
import com.yanny.ali.plugin.common.nodes.LootTableNode;
import com.yanny.ali.plugin.server.GenericTooltipUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.CompositeEntryBase;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import org.jetbrains.annotations.NotNull;

public class NodeUtils {
    public static void encodeTooltipNodes(IServerUtils ignoredUtils, FriendlyByteBuf buf, List<ITooltipNode> nodes) {
        buf.writeInt(nodes.size());
        for (ITooltipNode node : nodes) {
            node.encode(buf);
        }
    }

    @NotNull
    public static List<ITooltipNode> decodeTooltipNodes(IClientUtils ignoredUtils, FriendlyByteBuf buf) {
        int count = buf.readInt();
        ArrayList<ITooltipNode> nodes = new ArrayList<ITooltipNode>(count);
        for (int i = 0; i < count; ++i) {
            nodes.add(new TooltipNode(buf));
        }
        return nodes;
    }

    public static int getTotalWeight(List<LootPoolEntryContainer> entries) {
        int sum = 0;
        for (LootPoolEntryContainer entry : entries) {
            if (entry instanceof LootPoolSingletonContainer) {
                LootPoolSingletonContainer singletonContainer = (LootPoolSingletonContainer)entry;
                sum += singletonContainer.f_79675_;
                continue;
            }
            if (!(entry instanceof CompositeEntryBase)) continue;
            CompositeEntryBase compositeEntryBase = (CompositeEntryBase)entry;
            if (entry instanceof AlternativesEntry) {
                ++sum;
                continue;
            }
            sum += NodeUtils.getTotalWeight(Arrays.asList(compositeEntryBase.f_79428_));
        }
        return sum;
    }

    @NotNull
    public static List<Component> toComponents(List<ITooltipNode> tooltip, int pad, boolean showAdvancedTooltip) {
        ArrayList<Component> components = new ArrayList<Component>();
        for (ITooltipNode node : tooltip) {
            if (node.isAdvancedTooltip() && !showAdvancedTooltip) continue;
            components.addAll(NodeUtils.toComponents(node, pad, showAdvancedTooltip));
        }
        return components;
    }

    @NotNull
    public static List<Component> toComponents(ITooltipNode tooltip, int pad, boolean showAdvancedTooltip) {
        ArrayList<Component> components = new ArrayList<Component>();
        if (tooltip.getContent().m_214077_() != ComponentContents.f_237124_) {
            components.add(GenericTooltipUtils.pad(pad, tooltip.getContent()));
            components.addAll(NodeUtils.toComponents(tooltip.getChildren(), pad + 1, showAdvancedTooltip));
        } else {
            components.addAll(NodeUtils.toComponents(tooltip.getChildren(), pad, showAdvancedTooltip));
        }
        return components;
    }

    public static void processLootModifier(IServerUtils utils, ILootModifier<?> modifier, LootTableNode node) {
        List<IOperation> operations = modifier.getOperations();
        for (IOperation operation : operations) {
            if (operation instanceof IOperation.AddOperation) {
                IOperation.AddOperation addOperation = (IOperation.AddOperation)operation;
                node.addChildren(addOperation.node());
                continue;
            }
            if (operation instanceof IOperation.RemoveOperation) {
                IOperation.RemoveOperation removeOperation = (IOperation.RemoveOperation)operation;
                NodeUtils.removeItem(node, removeOperation.predicate());
                continue;
            }
            if (!(operation instanceof IOperation.ReplaceOperation)) continue;
            IOperation.ReplaceOperation replaceOperation = (IOperation.ReplaceOperation)operation;
            NodeUtils.replaceItem(utils, node, replaceOperation.factory(), replaceOperation.predicate());
        }
    }

    private static void removeItem(IDataNode node, Predicate<ItemStack> predicate) {
        if (node instanceof ListNode) {
            ListNode listNode = (ListNode)node;
            listNode.nodes().removeIf(n -> {
                if (n instanceof IItemNode) {
                    IItemNode itemNode = (IItemNode)((Object)n);
                    return NodeUtils.predicateEither(itemNode, predicate);
                }
                NodeUtils.removeItem(n, predicate);
                return false;
            });
            NodeUtils.removeEmptyNodes(node);
        }
    }

    private static void replaceItem(IServerUtils utils, IDataNode node, Function<IDataNode, List<IDataNode>> factory, Predicate<ItemStack> predicate) {
        if (node instanceof ListNode) {
            ListNode listNode = (ListNode)node;
            ArrayList nodes = new ArrayList();
            listNode.nodes().replaceAll(n -> {
                IItemNode itemNode;
                if (n instanceof IItemNode && NodeUtils.predicateEither(itemNode = (IItemNode)((Object)n), predicate)) {
                    List result = (List)factory.apply((IDataNode)n);
                    if (result.size() > 1) {
                        nodes.addAll(result.subList(1, result.size()));
                    }
                    return (IDataNode)result.get(0);
                }
                if (n instanceof ListNode) {
                    ListNode l = (ListNode)n;
                    NodeUtils.replaceItem(utils, l, factory, predicate);
                }
                return n;
            });
            nodes.forEach(listNode::addChildren);
        }
    }

    private static boolean hasItems(IDataNode node) {
        if (node instanceof ListNode) {
            ListNode listNode = (ListNode)node;
            return listNode.nodes().stream().anyMatch(NodeUtils::hasItems);
        }
        return node instanceof IItemNode;
    }

    private static void removeEmptyNodes(IDataNode node) {
        if (node instanceof ListNode) {
            ListNode listNode = (ListNode)node;
            listNode.nodes().removeIf(n -> !NodeUtils.hasItems(n));
        }
    }

    private static <T extends ItemLike> boolean predicateEither(IItemNode itemNode, Predicate<ItemStack> predicate) {
        return (Boolean)itemNode.getModifiedItem().map(predicate::test, tagKey -> {
            Registry registry = (Registry)BuiltInRegistries.f_257047_.m_7745_(tagKey.f_203867_().m_135782_());
            if (registry != null) {
                return registry.m_203431_(tagKey).map(holders -> holders.m_203614_().map(Holder::m_203334_)).orElse(Stream.of(new ItemLike[0])).map(i -> i.m_5456_().m_7968_()).allMatch(predicate);
            }
            return false;
        });
    }
}

