/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.manager;

import com.mojang.logging.LogUtils;
import com.yanny.ali.api.IClientRegistry;
import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.ICommonUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IWidget;
import com.yanny.ali.api.IWidgetUtils;
import com.yanny.ali.api.RelativeRect;
import com.yanny.ali.api.WidgetDirection;
import com.yanny.ali.manager.IOnDoneListener;
import com.yanny.ali.plugin.common.nodes.MissingNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;

public class AliClientRegistry
implements IClientRegistry,
IClientUtils {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int PADDING = 2;
    private final Map<ResourceLocation, IClientRegistry.IWidgetFactory> widgetMap = new HashMap<ResourceLocation, IClientRegistry.IWidgetFactory>();
    private final Map<ResourceLocation, IClientRegistry.NodeFactory<?>> nodeFactoryMap = new HashMap();
    private final Map<ResourceLocation, List<ItemStack>> lootItemMap = new HashMap<ResourceLocation, List<ItemStack>>();
    private final Map<ResourceLocation, IDataNode> lootNodeMap = new HashMap<ResourceLocation, IDataNode>();
    private final Map<ResourceLocation, IDataNode> lootTradeMap = new HashMap<ResourceLocation, IDataNode>();
    private final Map<ResourceLocation, List<Item>> tradeInputItemMap = new HashMap<ResourceLocation, List<Item>>();
    private final Map<ResourceLocation, List<Item>> tradeOutputItemMap = new HashMap<ResourceLocation, List<Item>>();
    private final ICommonUtils utils;
    private IOnDoneListener listener = null;
    private volatile boolean dataReceived = false;

    public AliClientRegistry(ICommonUtils utils) {
        this.utils = utils;
    }

    public void addLootData(ResourceLocation resourceLocation, IDataNode node, List<ItemStack> items) {
        this.lootItemMap.put(resourceLocation, items);
        this.lootNodeMap.put(resourceLocation, node);
    }

    public void addTradeData(ResourceLocation resourceLocation, IDataNode node, List<Item> inputs, List<Item> outputs) {
        this.lootTradeMap.put(resourceLocation, node);
        this.tradeInputItemMap.put(resourceLocation, inputs);
        this.tradeOutputItemMap.put(resourceLocation, outputs);
    }

    public synchronized void startLootData() {
        this.dataReceived = false;
        this.lootNodeMap.clear();
        this.lootTradeMap.clear();
        this.lootItemMap.clear();
        LOGGER.info("Started receiving loot data");
    }

    public synchronized void clearLootData() {
        this.listener = null;
        this.dataReceived = false;
        this.lootNodeMap.clear();
        this.lootTradeMap.clear();
        this.lootItemMap.clear();
        LOGGER.info("Cleared Loot data");
    }

    public synchronized void doneLootData() {
        this.dataReceived = true;
        LOGGER.info("Finished receiving loot data");
        if (this.listener != null) {
            LOGGER.info("Received data {}/{}", (Object)this.lootNodeMap.size(), (Object)this.lootTradeMap.size());
            this.listener.onDone(this.lootNodeMap, this.lootTradeMap);
            this.listener = null;
            this.dataReceived = false;
        }
    }

    public synchronized void setOnDoneListener(IOnDoneListener listener) {
        if (this.dataReceived) {
            LOGGER.info("Already done receiving data {}/{}", (Object)this.lootNodeMap.size(), (Object)this.lootTradeMap.size());
            listener.onDone(this.lootNodeMap, this.lootTradeMap);
            this.dataReceived = false;
        } else {
            LOGGER.info("Registered done listener");
            this.listener = listener;
        }
    }

    @Override
    public void registerWidget(ResourceLocation id, IClientRegistry.IWidgetFactory factory) {
        this.widgetMap.put(id, factory);
    }

    @Override
    public <T extends IDataNode> void registerNode(ResourceLocation id, IClientRegistry.NodeFactory<T> nodeFactory) {
        this.nodeFactoryMap.put(id, nodeFactory);
    }

    @Override
    public List<IWidget> createWidgets(IWidgetUtils utils, List<IDataNode> entries, RelativeRect parent, int maxWidth) {
        int posX = 0;
        int posY = 0;
        LinkedList<IWidget> widgets = new LinkedList<IWidget>();
        WidgetDirection lastDirection = null;
        for (IDataNode entry : entries) {
            IClientRegistry.IWidgetFactory widgetFactory = this.widgetMap.getOrDefault(entry.getId(), this.widgetMap.get(MissingNode.ID));
            IWidget widget = widgetFactory.create(utils, entry, new RelativeRect(posX, posY, parent.width - posX, 0, parent), maxWidth);
            RelativeRect bounds = widget.getRect();
            WidgetDirection direction = widget.getDirection();
            if (lastDirection == null) {
                if (direction == WidgetDirection.HORIZONTAL) {
                    posX += bounds.width;
                } else {
                    posY += bounds.height + 2;
                }
            } else if (lastDirection == WidgetDirection.HORIZONTAL && direction == WidgetDirection.HORIZONTAL) {
                if (bounds.getRight() <= maxWidth) {
                    posX += bounds.width;
                } else {
                    posX = bounds.width;
                    bounds.setOffset(0, posY += ((IWidget)widgets.get((int)(widgets.size() - 1))).getRect().height);
                }
            } else {
                posX = 0;
                if (direction != lastDirection) {
                    if (lastDirection == WidgetDirection.HORIZONTAL) {
                        posY += ((IWidget)widgets.get((int)(widgets.size() - 1))).getRect().height + 2;
                    }
                    bounds.setOffset(posX, posY);
                }
                posY += bounds.height + 2;
            }
            widgets.add(widget);
            lastDirection = direction;
        }
        int w = 0;
        int h = 0;
        for (IWidget widget : widgets) {
            RelativeRect rect = widget.getRect();
            w = Math.max(w, rect.offsetX + rect.width);
            h = Math.max(h, rect.offsetY + rect.height);
        }
        parent.setDimensions(w, h);
        return widgets;
    }

    @Override
    public <T extends IDataNode> IClientRegistry.NodeFactory<T> getNodeFactory(ResourceLocation id) {
        IClientRegistry.NodeFactory<?> nodeFactory = this.nodeFactoryMap.get(id);
        return Objects.requireNonNullElseGet(nodeFactory, () -> {
            throw new IllegalStateException(String.format("Failed to construct node - node {%s} was not registered!", id));
        });
    }

    @Override
    public List<ItemStack> getLootItems(ResourceLocation location) {
        return this.lootItemMap.getOrDefault(location, Collections.emptyList());
    }

    @Override
    public List<Item> getTradeInputItems(ResourceLocation location) {
        return this.tradeInputItemMap.getOrDefault(location, Collections.emptyList());
    }

    @Override
    public List<Item> getTradeOutputItems(ResourceLocation location) {
        return this.tradeOutputItemMap.getOrDefault(location, Collections.emptyList());
    }

    @Override
    public List<Entity> createEntities(EntityType<?> type, Level level) {
        return this.utils.createEntities(type, level);
    }

    public void printRegistrationInfo() {
        LOGGER.info("Registered {} widgets", (Object)this.widgetMap.size());
        LOGGER.info("Registered {} node factories", (Object)this.nodeFactoryMap.size());
        LOGGER.info("Registered {} trade factories", (Object)this.lootTradeMap.size());
    }
}

