/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.VanillaIngredientSerializer;

public class Ingredient
implements Predicate<ItemStack> {
    private static final AtomicInteger INVALIDATION_COUNTER = new AtomicInteger();
    public static final Ingredient f_43901_ = new Ingredient(Stream.empty());
    private final Value[] f_43902_;
    @Nullable
    private ItemStack[] f_43903_;
    @Nullable
    private IntList f_43904_;
    private int invalidationCounter;
    private final boolean isVanilla = this.getClass() == Ingredient.class;

    public static void invalidateAll() {
        INVALIDATION_COUNTER.incrementAndGet();
    }

    protected Ingredient(Stream<? extends Value> p_43907_) {
        this.f_43902_ = (Value[])p_43907_.toArray(Value[]::new);
    }

    public ItemStack[] m_43908_() {
        if (this.f_43903_ == null) {
            this.f_43903_ = (ItemStack[])Arrays.stream(this.f_43902_).flatMap(p_43916_ -> p_43916_.m_6223_().stream()).distinct().toArray(ItemStack[]::new);
        }
        return this.f_43903_;
    }

    @Override
    public boolean test(@Nullable ItemStack p_43914_) {
        if (p_43914_ == null) {
            return false;
        }
        if (this.m_43947_()) {
            return p_43914_.m_41619_();
        }
        for (ItemStack itemstack : this.m_43908_()) {
            if (!itemstack.m_150930_(p_43914_.m_41720_())) continue;
            return true;
        }
        return false;
    }

    public IntList m_43931_() {
        if (this.f_43904_ == null || this.checkInvalidation()) {
            this.markValid();
            ItemStack[] aitemstack = this.m_43908_();
            this.f_43904_ = new IntArrayList(aitemstack.length);
            for (ItemStack itemstack : aitemstack) {
                this.f_43904_.add(StackedContents.m_36496_((ItemStack)itemstack));
            }
            this.f_43904_.sort(IntComparators.NATURAL_COMPARATOR);
        }
        return this.f_43904_;
    }

    public final void m_43923_(FriendlyByteBuf p_43924_) {
        if (!this.isVanilla()) {
            CraftingHelper.write((FriendlyByteBuf)p_43924_, (Ingredient)this);
            return;
        }
        p_43924_.m_236828_(Arrays.asList(this.m_43908_()), FriendlyByteBuf::m_130055_);
    }

    public JsonElement m_43942_() {
        if (this.f_43902_.length == 1) {
            return this.f_43902_[0].m_6544_();
        }
        JsonArray jsonarray = new JsonArray();
        for (Value ingredient$value : this.f_43902_) {
            jsonarray.add((JsonElement)ingredient$value.m_6544_());
        }
        return jsonarray;
    }

    public boolean m_43947_() {
        return this.f_43902_.length == 0;
    }

    public final boolean checkInvalidation() {
        int currentInvalidationCounter = INVALIDATION_COUNTER.get();
        if (this.invalidationCounter != currentInvalidationCounter) {
            this.invalidate();
            return true;
        }
        return false;
    }

    protected final void markValid() {
        this.invalidationCounter = INVALIDATION_COUNTER.get();
    }

    protected void invalidate() {
        this.f_43903_ = null;
        this.f_43904_ = null;
    }

    public boolean isSimple() {
        return true;
    }

    public final boolean isVanilla() {
        return this.isVanilla;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        if (!this.isVanilla()) {
            throw new IllegalStateException("Modders must implement Ingredient.getSerializer in their custom Ingredients: " + String.valueOf(this));
        }
        return VanillaIngredientSerializer.INSTANCE;
    }

    public static Ingredient m_43938_(Stream<? extends Value> p_43939_) {
        Ingredient ingredient = new Ingredient(p_43939_);
        return ingredient.m_43947_() ? f_43901_ : ingredient;
    }

    public static Ingredient m_151265_() {
        return f_43901_;
    }

    public static Ingredient m_43929_(ItemLike ... p_43930_) {
        return Ingredient.m_43921_(Arrays.stream(p_43930_).map(ItemStack::new));
    }

    public static Ingredient m_43927_(ItemStack ... p_43928_) {
        return Ingredient.m_43921_(Arrays.stream(p_43928_));
    }

    public static Ingredient m_43921_(Stream<ItemStack> p_43922_) {
        return Ingredient.m_43938_(p_43922_.filter(p_43944_ -> !p_43944_.m_41619_()).map(ItemValue::new));
    }

    public static Ingredient m_204132_(TagKey<Item> p_204133_) {
        return Ingredient.m_43938_(Stream.of(new TagValue(p_204133_)));
    }

    public static Ingredient m_43940_(FriendlyByteBuf p_43941_) {
        int size = p_43941_.m_130242_();
        if (size == -1) {
            return CraftingHelper.getIngredient((ResourceLocation)p_43941_.m_130281_(), (FriendlyByteBuf)p_43941_);
        }
        return Ingredient.m_43938_(Stream.generate(() -> new ItemValue(p_43941_.m_130267_())).limit(size));
    }

    public static Ingredient m_43917_(@Nullable JsonElement p_43918_) {
        return Ingredient.m_288218_(p_43918_, true);
    }

    public static Ingredient m_288218_(@Nullable JsonElement p_289022_, boolean p_288974_) {
        if (p_289022_ != null && !p_289022_.isJsonNull()) {
            Ingredient ret = CraftingHelper.getIngredient((JsonElement)p_289022_, (boolean)p_288974_);
            if (ret != null) {
                return ret;
            }
            if (p_289022_.isJsonObject()) {
                return Ingredient.m_43938_(Stream.of(Ingredient.m_43919_(p_289022_.getAsJsonObject())));
            }
            if (p_289022_.isJsonArray()) {
                JsonArray jsonarray = p_289022_.getAsJsonArray();
                if (jsonarray.size() == 0 && !p_288974_) {
                    throw new JsonSyntaxException("Item array cannot be empty, at least one item must be defined");
                }
                return Ingredient.m_43938_(StreamSupport.stream(jsonarray.spliterator(), false).map(p_289756_ -> Ingredient.m_43919_(GsonHelper.m_13918_((JsonElement)p_289756_, (String)"item"))));
            }
            throw new JsonSyntaxException("Expected item to be object or array of objects");
        }
        throw new JsonSyntaxException("Item cannot be null");
    }

    public static Value m_43919_(JsonObject p_289797_) {
        if (p_289797_.has("item") && p_289797_.has("tag")) {
            throw new JsonParseException("An ingredient entry is either a tag or an item, not both");
        }
        if (p_289797_.has("item")) {
            Item item = ShapedRecipe.m_151278_(p_289797_);
            return new ItemValue(new ItemStack(item));
        }
        if (p_289797_.has("tag")) {
            ResourceLocation resourcelocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)p_289797_, (String)"tag"));
            TagKey tagkey = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)resourcelocation);
            return new TagValue((TagKey<Item>)tagkey);
        }
        throw new JsonParseException("An ingredient entry needs either a tag or an item");
    }

    public static Ingredient merge(Collection<Ingredient> parts) {
        return Ingredient.m_43938_(parts.stream().flatMap(i -> Arrays.stream(i.f_43902_)));
    }

    public static interface Value {
        public Collection<ItemStack> m_6223_();

        public JsonObject m_6544_();
    }

    public static class TagValue
    implements Value {
        private final TagKey<Item> f_43959_;

        public TagValue(TagKey<Item> p_204135_) {
            this.f_43959_ = p_204135_;
        }

        @Override
        public Collection<ItemStack> m_6223_() {
            ArrayList list = Lists.newArrayList();
            for (Holder holder : BuiltInRegistries.f_257033_.m_206058_(this.f_43959_)) {
                list.add(new ItemStack(holder));
            }
            if (list.size() == 0) {
                list.add(new ItemStack(Blocks.f_50375_).m_41714_((Component)Component.m_237113_((String)("Empty Tag: " + String.valueOf(this.f_43959_.f_203868_())))));
            }
            return list;
        }

        @Override
        public JsonObject m_6544_() {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("tag", this.f_43959_.f_203868_().toString());
            return jsonobject;
        }
    }

    public static class ItemValue
    implements Value {
        private final ItemStack f_43951_;

        public ItemValue(ItemStack p_43953_) {
            this.f_43951_ = p_43953_;
        }

        @Override
        public Collection<ItemStack> m_6223_() {
            return Collections.singleton(this.f_43951_);
        }

        @Override
        public JsonObject m_6544_() {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)this.f_43951_.m_41720_()).toString());
            return jsonobject;
        }
    }
}

