/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.linkfs.LinkFileSystem;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import org.slf4j.Logger;

public class FolderRepositorySource
implements RepositorySource {
    private static final Logger f_244616_ = LogUtils.getLogger();
    private final Path f_10382_;
    private final PackType f_243749_;
    private final PackSource f_10383_;

    public FolderRepositorySource(Path p_251796_, PackType p_251664_, PackSource p_250854_) {
        this.f_10382_ = p_251796_;
        this.f_243749_ = p_251664_;
        this.f_10383_ = p_250854_;
    }

    private static String m_246927_(Path p_248745_) {
        return p_248745_.getFileName().toString();
    }

    @Override
    public void m_7686_(Consumer<Pack> p_250965_) {
        try {
            FileUtil.m_257659_(this.f_10382_);
            FolderRepositorySource.m_247293_(this.f_10382_, false, (p_248243_, p_248244_) -> {
                String $$3 = FolderRepositorySource.m_246927_(p_248243_);
                Pack $$4 = Pack.m_245429_("file/" + $$3, Component.m_237113_($$3), false, p_248244_, this.f_243749_, Pack.Position.TOP, this.f_10383_);
                if ($$4 != null) {
                    p_250965_.accept($$4);
                }
            });
        }
        catch (IOException $$1) {
            f_244616_.warn("Failed to list packs in {}", (Object)this.f_10382_, (Object)$$1);
        }
    }

    public static void m_247293_(Path p_248794_, boolean p_255987_, BiConsumer<Path, Pack.ResourcesSupplier> p_248580_) throws IOException {
        try (DirectoryStream<Path> $$3 = Files.newDirectoryStream(p_248794_);){
            for (Path $$4 : $$3) {
                Pack.ResourcesSupplier $$5 = FolderRepositorySource.m_254985_($$4, p_255987_);
                if ($$5 == null) continue;
                p_248580_.accept($$4, $$5);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static Pack.ResourcesSupplier m_254985_(Path p_255665_, boolean p_255971_) {
        FileSystem $$6;
        void $$5;
        try {
            BasicFileAttributes $$2 = Files.readAttributes(p_255665_, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (NoSuchFileException $$3) {
            return null;
        }
        catch (IOException $$4) {
            f_244616_.warn("Failed to read properties of '{}', ignoring", (Object)p_255665_, (Object)$$4);
            return null;
        }
        if ($$5.isDirectory() && Files.isRegularFile(p_255665_.resolve("pack.mcmeta"), new LinkOption[0])) {
            return p_255538_ -> new PathPackResources(p_255538_, p_255665_, p_255971_);
        }
        if ($$5.isRegularFile() && p_255665_.getFileName().toString().endsWith(".zip") && (($$6 = p_255665_.getFileSystem()) == FileSystems.getDefault() || $$6 instanceof LinkFileSystem)) {
            File $$7 = p_255665_.toFile();
            return p_255541_ -> new FilePackResources(p_255541_, $$7, p_255971_);
        }
        f_244616_.info("Found non-pack entry '{}', ignoring", (Object)p_255665_);
        return null;
    }
}

