/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.cl;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ModularURLHandler
implements URLStreamHandlerFactory {
    public static final ModularURLHandler INSTANCE = new ModularURLHandler();
    private Map<String, IURLProvider> handlers;

    public static void initFrom(ModuleLayer layer) {
        ModularURLHandler.INSTANCE.handlers = layer == null ? null : ServiceLoader.load(layer, IURLProvider.class).stream().map(ServiceLoader.Provider::get).collect(Collectors.toMap(IURLProvider::protocol, Function.identity()));
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        if (this.handlers == null) {
            return null;
        }
        if (this.handlers.containsKey(protocol)) {
            return new FunctionURLStreamHandler(this.handlers.get(protocol));
        }
        return null;
    }

    public static interface IURLProvider {
        public String protocol();

        public Function<URL, InputStream> inputStreamFunction();
    }

    private static class FunctionURLStreamHandler
    extends URLStreamHandler {
        private final IURLProvider iurlProvider;

        public FunctionURLStreamHandler(IURLProvider iurlProvider) {
            this.iurlProvider = iurlProvider;
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            return new FunctionURLConnection(u, this.iurlProvider);
        }
    }

    private static class FunctionURLConnection
    extends URLConnection {
        private final IURLProvider provider;

        protected FunctionURLConnection(URL url, IURLProvider provider) {
            super(url);
            this.provider = provider;
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            try {
                return this.provider.inputStreamFunction().apply(this.url);
            }
            catch (UncheckedIOException e) {
                throw e.getCause();
            }
        }
    }
}

