/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class FilePackResources
extends AbstractPackResources {
    private static final Logger f_215322_ = LogUtils.getLogger();
    public static final Splitter f_10232_ = Splitter.on((char)'/').omitEmptyStrings().limit(3);
    private final File f_243750_;
    @Nullable
    private ZipFile f_10233_;
    private boolean f_243662_;

    public FilePackResources(String p_256076_, File p_255707_, boolean p_256556_) {
        super(p_256076_, p_256556_);
        this.f_243750_ = p_255707_;
    }

    @Nullable
    private ZipFile m_10247_() {
        if (this.f_243662_) {
            return null;
        }
        if (this.f_10233_ == null) {
            try {
                this.f_10233_ = new ZipFile(this.f_243750_);
            }
            catch (IOException $$0) {
                f_215322_.error("Failed to open pack {}", (Object)this.f_243750_, (Object)$$0);
                this.f_243662_ = true;
                return null;
            }
        }
        return this.f_10233_;
    }

    private static String m_245721_(PackType p_250585_, ResourceLocation p_251470_) {
        return String.format(Locale.ROOT, "%s/%s/%s", p_250585_.m_10305_(), p_251470_.m_135827_(), p_251470_.m_135815_());
    }

    @Override
    @Nullable
    public IoSupplier<InputStream> m_8017_(String ... p_248514_) {
        return this.m_247280_(String.join((CharSequence)"/", p_248514_));
    }

    @Override
    public IoSupplier<InputStream> m_214146_(PackType p_249605_, ResourceLocation p_252147_) {
        return this.m_247280_(FilePackResources.m_245721_(p_249605_, p_252147_));
    }

    @Nullable
    private IoSupplier<InputStream> m_247280_(String p_251795_) {
        ZipFile $$1 = this.m_10247_();
        if ($$1 == null) {
            return null;
        }
        ZipEntry $$2 = $$1.getEntry(p_251795_);
        if ($$2 == null) {
            return null;
        }
        return IoSupplier.m_247178_($$1, $$2);
    }

    @Override
    public Set<String> m_5698_(PackType p_10238_) {
        ZipFile $$1 = this.m_10247_();
        if ($$1 == null) {
            return Set.of();
        }
        Enumeration<? extends ZipEntry> $$2 = $$1.entries();
        HashSet $$3 = Sets.newHashSet();
        while ($$2.hasMoreElements()) {
            ArrayList $$6;
            ZipEntry $$4 = $$2.nextElement();
            String $$5 = $$4.getName();
            if (!$$5.startsWith(p_10238_.m_10305_() + "/") || ($$6 = Lists.newArrayList((Iterable)f_10232_.split((CharSequence)$$5))).size() <= 1) continue;
            String $$7 = (String)$$6.get(1);
            if ($$7.equals($$7.toLowerCase(Locale.ROOT))) {
                $$3.add($$7);
                continue;
            }
            f_215322_.warn("Ignored non-lowercase namespace: {} in {}", (Object)$$7, (Object)this.f_243750_);
        }
        return $$3;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    public void close() {
        if (this.f_10233_ != null) {
            IOUtils.closeQuietly((Closeable)this.f_10233_);
            this.f_10233_ = null;
        }
    }

    @Override
    public void m_8031_(PackType p_250500_, String p_249598_, String p_251613_, PackResources.ResourceOutput p_250655_) {
        ZipFile $$4 = this.m_10247_();
        if ($$4 == null) {
            return;
        }
        Enumeration<? extends ZipEntry> $$5 = $$4.entries();
        String $$6 = p_250500_.m_10305_() + "/" + p_249598_ + "/";
        String $$7 = $$6 + p_251613_ + "/";
        while ($$5.hasMoreElements()) {
            String $$9;
            ZipEntry $$8 = $$5.nextElement();
            if ($$8.isDirectory() || !($$9 = $$8.getName()).startsWith($$7)) continue;
            String $$10 = $$9.substring($$6.length());
            ResourceLocation $$11 = ResourceLocation.m_214293_(p_249598_, $$10);
            if ($$11 != null) {
                p_250655_.accept($$11, IoSupplier.m_247178_($$4, $$8));
                continue;
            }
            f_215322_.warn("Invalid path in datapack: {}:{}, ignoring", (Object)p_249598_, (Object)$$10);
        }
    }
}

